﻿using System;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIRP.AHOBPR.BLL
{
    [Serializable]
    public class AHOBPREmailService
    {
        [NonSerialized]
        private SqlDataStore dataSource;
        [NonSerialized]
        private AHOBPRLinqDataContext db = GetDataContext();
        public static AHOBPREmailTemplateManager templateDao;

        public class EmailDto
        {
            public string Email { get; set; }

        }

        public AHOBPREmailService()
        {
            if (templateDao == null)
                templateDao = new AHOBPREmailTemplateManager();
            if (dataSource == null)
                dataSource = new SqlDataStore();
        }

        public virtual EMailMessage CreateMessage(int templateId, string from, StringCollection toList)
        {
            EMAIL_TEMPLATE template = templateDao.GetById(templateId);

            string body = template.SALUTATION + "\r\n\r\n" + template.BODY + "\r\n\r\n" + template.CONTACT_INFO;
            body.Replace("\r\n\r\n\r\n\r\n", "\r\n\r\n");
            EMailMessage msg = new EMailMessage(HttpUtility.HtmlDecode(template.SUBJECT), HttpUtility.HtmlDecode(body), from, toList);
            return msg;
        }

        public virtual EMailMessage CreateMessage(int templateId, string from, string to)
        {
            EMAIL_TEMPLATE template = templateDao.GetById(templateId);

            EMailMessage msg = new EMailMessage(HttpUtility.HtmlDecode(template.SUBJECT), HttpUtility.HtmlDecode(template.BODY), from, to);
            return msg;
        }

        public StringDictionary GetTemplateData(string storeproc)
        {
            StringDictionary collection = new StringDictionary();
            SqlDataStore.RowReader rowReader = (SqlDataStore adapter, IDataReader reader) =>
            {
                collection.Add(adapter.GetString(reader, 0), adapter.GetString(reader, 1));
            };
            dataSource.ExecuteReader(rowReader, storeproc);
            return collection;
        }

        /// <summary>
        /// </summary>
        /// <param name="userId"></param>
        /// <returns></returns>
        public StringCollection GetEmailListForRegistrant(int registrantId)
        {
            StringCollection collection = new StringCollection();
            IList<EmailDto> registrants = GetEmailAddresses(registrantId);

            foreach (EmailDto registrant in registrants)
            {
                if (!string.IsNullOrEmpty(registrant.Email))
                {
                    if (!collection.Contains(registrant.Email))
                    {
                        collection.Add(registrant.Email);
                    }
                }

            }

            return collection;
        }

        /***New Code ******************************************/

        /// <summary>
        /// Private DAO Member
        /// </summary>
        static AHOBPREmailTemplateManager _EmailTemplateDao;

        /// <summary>
        /// Public DAO Member
        /// </summary>
        public static AHOBPREmailTemplateManager EmailTemplateDao
        {
            get
            {
                if (_EmailTemplateDao == null)
                    _EmailTemplateDao = new AHOBPREmailTemplateManager();

                return _EmailTemplateDao;
            }
        }

        /// <summary>
        /// Direct Call to the DAO.
        /// </summary>
        /// <param name="emailTemplate"></param>
        //public static void SaveOrUpdate(EmailTemplate emailTemplate)
        //{
        //    EmailTemplateDao.SaveOrUpdate(emailTemplate);
        //}

        /// <summary>
        /// Method to send an email to registrants applying for the registry when their status changes
        /// </summary>
        /// <param name="refId"></param>
        /// <param name="userId"></param>
        /// <param name="caseId"></param>
        /// <param name="HostName">Host Url, just use the following static call -- Utility.GetHostName().</param>
        public void SendEmailToRegistrant(int registrantId, int templateId, StringCollection registrantEmailList, int sendMessageType, string createdBy)
        {
            string registrantName = SelectRegistrantName(registrantId);

            AHOBPREmailService mailService = new AHOBPREmailService();
            AHOBPRMailManager emails = new AHOBPRMailManager(mailService);
            emails.AddTemplate(templateId, "", registrantEmailList);
            emails.SetField("REGISTRANTNAME", registrantName);
            emails.SetField("NEWLINE", Environment.NewLine);
            emails.SendAll(registrantId, templateId, sendMessageType, true, createdBy);
        }

        public void SendEmailToUser(int userId, string userFullName, int templateId, string emailAddress, string createdBy)
        {
            if (!string.IsNullOrEmpty(emailAddress))
            {
                StringCollection emailList = new StringCollection();
                emailList.Add(emailAddress);
                AHOBPREmailService mailService = new AHOBPREmailService();
                AHOBPRMailManager emails = new AHOBPRMailManager(mailService);
                emails.AddTemplate(templateId, "", emailList);
                emails.SetField("USERNAME", userFullName);
                emails.SetField("NEWLINE", Environment.NewLine);
                emails.SendAll(userId, templateId, (int)Enums.messageType.sendEmail, false, createdBy);
            }
        }
        public IList<EmailDto> GetEmailAddresses(int registrantId)
        {
            return (from list in db.REGISTRANT_EMAILs
                    where (list.REGISTRANT_ID == registrantId)
                    select new EmailDto
                    {
                        Email = list.EMAIL

                    })
                   .ToList<EmailDto>();
        }

        public string SelectRegistrantName(int registrantId)
        {
            string registrant = string.Empty;

            using (_dbAhobpr = GetDataContext())
            {
                registrant = (from r in _dbAhobpr.REGISTRANTs
                              where r.REGISTRANT_ID == registrantId
                              select r.FIRST_NAME + "  " + r.LAST_NAME).FirstOrDefault();

            }
            return registrant;
        }

        public int GetMessageType(int templateId)
        {
            EMAIL_TEMPLATE emailTemplate;
            int messageType = 0;

            using (_dbAhobpr = GetDataContext())
            {
                emailTemplate = (from e in _dbAhobpr.EMAIL_TEMPLATEs
                                 where e.TEMPLATE_ID == templateId
                                 select e).FirstOrDefault();

            }

            //messageType:
            // 1 = send Email 
            // 2 = send Notification 
            // 3 = send Both an email and notification 
            if (emailTemplate.EMAIL == true && emailTemplate.NOTIFICATION == true)
            {
                messageType = 3;
            }
            else if (emailTemplate.EMAIL == true)
            {
                messageType = 1;
            }
            else if (emailTemplate.NOTIFICATION == true)
            {
                messageType = 2;
            }

            return messageType;
        }
    }

}

